<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Commands;
use common\models\Bots;

/**
 * CommandsSearch represents the model behind the search form about `common\models\Commands`.
 */
class CommandsSearch extends Commands
{
    public $admin;
    public $botname;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'bot_id', 'status', 'commandtype'], 'integer'],
            [['created_at', 'command', 'result', 'admin', 'botname'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        //$query = Commands::find()->joinWith(['user']);
        $query = Commands::find()->joinWith([
            'admin', 
            'botname' => function ($q) { $q->from(Bots::tableName() . ' botname' ); }
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $dataProvider->sort->attributes['user'] = [
            'asc' => ['admin.login' => SORT_ASC],
            'desc' => ['admin.login' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['botname'] = [
            'asc' => ['botname.bot' => SORT_ASC],
            'desc' => ['botname.bot' => SORT_DESC],
        ];

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'bot_id' => $this->bot_id,
            'status' => $this->status,
            'commandtype' => $this->commandtype,
        ]);

        $query->andFilterWhere(['like', 'command', $this->command])
            ->andFilterWhere(['like', 'result', $this->result])
            ->andFilterWhere(['like', 'admin.login', $this->admin])
            ->andFilterWhere(['like', 'botname.bot', $this->botname]);

        return $dataProvider;
    }
}
